# Prompts
def system_prompt():
    # prompt = "You will be given images of an object at increasing levels of granularity. For each image, name the part of the object masked in blue. Use the context of previous images to aid in your classification. Also, give a confidence score for the classification of either [sure, unsure, impossible]. For example, \"chair leg, sure\"."
    # prompt = "You will be give images and your purpose is to classify and label the objects in the image. I will start by giving you the full image, and iteratively feed you part-level cutouts and I need you to label each part as accurately as possible."
    # prompt = "I will give you images and your purpose is to classify and label the objects in the image. I will start by giving you the full image, and iteratively feed you part-level cutouts and I need you to label each part as accurately as possible. Do not reference sections of the image masked in black. Only describe the visible part. Answer in a single sentence, but be detailed."
    # prompt = """
    #     You are an expert in object part segmentation and labeling. 
    #     Your task is to analyze images of objects and their subsections, identifying and labeling each part in a hierarchical manner. 
    #     A subsection image is the image with parts masked out in black. You will focus on the part not masked in black.
    #     Each presented image is guaranteed to be a subsection of the previous image.
    #     Labels should be complete, describing all visible parts.
    #
    #     In addition to a label, assign a confidence score for each prediction. This score should reflect the ambiguity of the subsection.
    #     For example, subsections that are too small, are extreme closeups, have too much noise, or do not have semantic meaning should have scores near 0.
    #
    #     When presented with an image or a subsection, your response must follow this structured format:
    #     1. **Thinking**: Provide internal reasoning for the label, including how the depicted part relates to the existing hierarchy. 
    #     2. **Label**: Provide a clear, descriptive name for the identified object or part (as a string).
    #     3. **Confidence Score**: Assign a confidence score (from 0 to 1) for your prediction, where 1 indicates high confidence and 0 indicates no confidence (as a float). 
    #
    #     Use <think>...</think> tags for internal reasoning before responding
    #     Your responses must strictly adhere to the following format for easy parsing:
    #     - <think>[text explanation]</think>
    #     - <label>[string]</label>
    #     - <score>[float]</score>
    #
    #     If ambiguity arises, explain your assumptions and assign a lower confidence score accordingly.
    #     """
        # - Label images holistically. Do not prematurely reference parts unless it describes the entire visible image.
        # - Do not reference parent labels unless necessary. 
        # - Avoid nondescript words or words describing the camera angle, e.g., "closeup" or "zoomed-in"
    prompt = """
        You are an expert in object part segmentation and labeling. 
        Your task is to analyze images of objects and their subsections, identifying and labeling each part in a hierarchical manner. 
        A subsection image is the image with parts masked out in black. You will focus on the part not masked in black.
        Each presented image is guaranteed to be a subsection of the previous image.

        In addition to a label, assign a confidence score for each prediction. This score should reflect the ambiguity of the subsection.
        For example, subsections that are too small, are extreme closeups, have too much noise, or do not have semantic meaning should have scores near 0.
        If ambiguity arises, explain your assumptions and assign a lower confidence score accordingly.

        Guidelines:
        Labels should describe the entire visible image.
        Think carefully, step by step, before labeling. Use knowledge about the object category and the parts that typically make up the object. Use spatial reasoning of where the part segments are located relative to the previous images.
        Label images holistically. Do not prematurely reference parts unless it describes the entire visible image.
        If the image looks identical to the previous image, simply repeat the previous label.
        Do not reference previous labels unless necessary. For example, instead of "chair leg" just say "leg"


        When presented with an image, your response must follow this structured format:
        1. **Thinking**: Provide internal reasoning for the label, including how the depicted part relates to the existing hierarchy. 
        2. **Label**: Provide a clear, descriptive name for the identified object or part (as a string).
        3. **Confidence Score**: Assign a confidence score (from 0 to 1) for your prediction, where 1 indicates high confidence and 0 indicates no confidence (as a float). 

        Use <think>...</think> tags for internal reasoning before responding
        Your responses must strictly adhere to the following format for easy parsing:
        <think>[text explanation]</think>
        <label>[string]</label>
        <score>[float]</score>

        """

    return prompt

def root_query_prompt():
    # prompt = "What is the depicted object?"
    # prompt = "Describe the depicted object."
    prompt = """
        Analyze the following image of an object.
        Identify and label the object, and provide a confidence score (from 0 to 1) for your prediction. 
        """
    # prompt = """
    #     Analyze the following image of an object.
    #     Identify and label the object, and provide a continue score (0 or 1) for your prediction. 
    #     """
    return prompt

def query_prompt():
    # prompt = "Describe this part of the previous object. Do not reference the black masked sections."
    prompt = """
        The following image is a subsection of the previously analyzed part.
        Analyze this subsection, identify and label it, and provide a confidence score (from 0 to 1) for your prediction.
        """
    # prompt = """
    #     The following image is a subsection of the previously analyzed part.
    #     Identify and label the object, and provide a continue score (0 or 1) for your prediction. 
    #     """
    return prompt
